//
//  YHGrabNumberListView.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGrabingNumberListView: UIView {

    var cancelBlock: (()->())?
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var markView:UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var cancelAppointBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .white
        btn.titleLabel?.font = .PFSC_M(ofSize: 12)
        btn.setTitle("取消预约", for: .normal)
        btn.setTitleColor(.brandMainColor, for: .normal)
        btn.layer.cornerRadius = kCornerRadius3
        btn.layer.borderWidth = 1.0
        btn.layer.borderColor = UIColor.brandMainColor.cgColor
        btn.addTarget(self, action: #selector(didCancelBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var membersLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "成员："
        label.textColor = .mainTextColor(alpha: 0.7)
        return label
    }()
    
    lazy var grabInfoView: YHGrabNumberInfoView = {
        let view = YHGrabNumberInfoView(frame: .zero)
        view.titleLabel.text = "抢号信息"
        let items = [YHGrabItem(type: .grab, title: "赴港时间：", detail: "抢号中", isSingleLine: true),
                      YHGrabItem(type: .grab, title: "香港入境处：", detail: "抢号中", isSingleLine: true),
                      YHGrabItem(type: .grab, title: "抢号反馈回执：", detail: "抢号中", isSingleLine: true),]
        view.updateItems(items)
        return view
    }()
    
    lazy var intentionInfoView: YHGrabNumberInfoView = {
        let view = YHGrabNumberInfoView(frame: .zero)
        view.titleLabel.text = "意向信息"
        let items = [YHGrabItem(type: .info, title: "期望赴港时间：", detail: "", isSingleLine: true),
                     YHGrabItem(type: .info, title: "期望香港办证点：", detail: "", isSingleLine: false),
                     YHGrabItem(type: .files, title: "抢号反馈回执：", detail: "", isSingleLine: true),]
        view.updateItems(items)
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    @objc func didCancelBtnClicked() {
        cancelBlock?()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(lineView)
        self.addSubview(markView)
        self.addSubview(titleLabel)
        self.addSubview(cancelAppointBtn)
        self.addSubview(membersLabel)
        self.addSubview(grabInfoView)
        self.addSubview(intentionInfoView)
        
        lineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        cancelAppointBtn.snp.makeConstraints { make in
            make.top.equalTo(12)
            make.right.equalTo(0)
            make.size.equalTo(CGSizeMake(70, 32))
        }
        
        markView.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(3, 14))
            make.left.equalTo(0)
            make.centerY.equalTo(cancelAppointBtn)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(markView.snp.right).offset(6)
            make.height.equalTo(22)
            make.centerY.equalTo(cancelAppointBtn)
        }
        
        membersLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        grabInfoView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(membersLabel.snp.bottom).offset(16)
        }
        
        intentionInfoView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(grabInfoView.snp.bottom).offset(16)
            make.bottom.equalTo(0)
        }
    }
}
